local t = Def.ActorFrame {};
-- A very useful table...
local eval_lines = {
	"W1",
	"W2",
	"W3",
	"W4",
	"W5",
	"Miss",
	"Held",
	"MaxCombo"
}

-- And a function to make even better use out of the table.
local function GetJLineValue(line, pl)
	if line == "Held" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetHoldNoteScores("HoldNoteScore_Held")
	elseif line == "MaxCombo" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):MaxCombo()
	else
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetTapNoteScores("TapNoteScore_" .. line)
	end
	return "???"
end

-- #################################################
-- That's enough functions; let's get this done.


t[#t+1] = mid_pane

-- #################################################
-- Player stats and labels 
local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward();
local comboType = ThemePrefs.Get("GreatContinuesCombo")
local goodfc = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):FullComboOfScore('TapNoteScore_W4');
local goods = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores('TapNoteScore_W4');
local ex2 = GAMESTATE:IsExtraStage2();
local fail = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetFailed();
if GAMESTATE:IsHumanPlayer(PLAYER_1) then 
	local p1evalx = SCREEN_CENTER_X-420
	local p1evaly = SCREEN_TOP+150
	local eval_offset = 44
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade()

	-- FC Badge P1
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(horizalign,center;x,p1evalx+100;y,p1evaly-40;);
		OnCommand=function(self)
			if fail then
				return
			elseif award then
				if award == 'StageAward_FullComboW1' then
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(0.5):diffusealpha(1)
				else
					self:zoom(1):diffusealpha(0):sleep(1.7):accelerate(0.3):zoom(0.3):diffusealpha(1);
				end
			elseif goodfc then
				self:zoom(1):diffusealpha(0):sleep(1.7):accelerate(0.3):zoom(0.3):diffusealpha(1);
			end
		end;
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor("_w4badge") .. {
			OnCommand=function(self)
				if fail then
					self:visible(false)
				elseif not fail then
					if comboType == 'TapNoteScore_W4' and goodfc and goods == 1 then
						self:visible(true):vibrate()
					elseif comboType == 'TapNoteScore_W4' and goodfc and goods ~= 0 then
						self:visible(true)
					elseif fail then
						self:visible(false)
					else
						self:visible(false)
					end
				end
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
		LoadActor("_w3badge") .. {
			OnCommand=function(self)
				if award == 'StageAward_FullComboW3' then
					self:visible(true)
				elseif award == 'StageAward_SingleDigitW3' then
					self:visible(true)
				elseif award == 'StageAward_OneW3' then
					self:visible(true):vibrate()
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};

	
		LoadActor("_w2badge") .. {
			OnCommand=function(self)
				if award == 'StageAward_FullComboW2' then
					self:visible(true)
				elseif award == 'StageAward_SingleDigitW2' then
					self:visible(true)
				elseif award == 'StageAward_OneW2' then
					self:visible(true):vibrate()
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};	
		
		LoadActor("_sdplus") .. {
			InitCommand=function(self) self:addx(60):addy(-75) end;
			AppearCommand=function(self) self:zoom(0):sleep(2.4):decelerate(0.2):zoom(1.25):diffusealpha(1):accelerate(0.2):zoom(1) end;
			OnCommand=function(self)
				if not fail and goodfc and goods <= 9 and goods >= 2 then
					self:visible(true):queuecommand("Appear")
				elseif award == 'StageAward_SingleDigitW3' then
					self:visible(true):queuecommand("Appear")
				elseif award == 'StageAward_SingleDigitW2' then
					self:visible(true):queuecommand("Appear")
				elseif not fail and goodfc and goods == 1 then
					self:visible(true):queuecommand("Appear"):vibrate()
				elseif award == 'StageAward_OneW3' then
					self:visible(true):queuecommand("Appear"):vibrate()
				elseif award == 'StageAward_OneW2' then
					self:visible(true):queuecommand("Appear"):vibrate()
				elseif fail then
					self:visible(false)
				else
					self:visible(false)
				end;
			end;
		};	
	};
	t[#t+1] = Def.ActorFrame { -- MFC badge standalone
		LoadActor("_bw1badge") .. {
			InitCommand=function(self) self:xy(107,132) end;
			OnCommand=function(self)
				if award == 'StageAward_FullComboW1' then
					self:visible(true):zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(0.5):diffusealpha(1)
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
	};	
	-- Sounds
	t[#t+1] = Def.ActorFrame {
		LoadActor("_badge") .. {
			OnCommand=function(self) self:sleep(1.9):queuecommand("Play") end;
			PlayCommand=function(self)
				if fail then
					self:stop()
				elseif award then
					if award ~= 'StageAward_FullComboW1' then
						self:play()
					else
						self:stop()
					end
				elseif goodfc then
					self:play()
				else
					self:stop()
				end
			end;
		};
		LoadActor("_perfect") .. {
			OnCommand=function(self) self:sleep(1.45):queuecommand("Play") end;
			PlayCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward();
				if award == 'StageAward_FullComboW1' then
					self:play()
				else
					self:stop()
				end
			end;
		};
		LoadActor("_plus") .. {
			OnCommand=function(self) self:sleep(2.3):queuecommand("Play") end;
			PlayCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward();
				if award == 'StageAward_SingleDigitW3' or award == 'StageAward_OneW3' then
					self:play()
				elseif award == 'StageAward_SingleDigitW2' or award == 'StageAward_OneW2' then
					self:play()
				elseif not ex2 and goodfc and goods >= 1 and goods <= 9 then
					self:play()
				else
					self:stop()
				end
			end;
		};
	};
	
	--Grade P1
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.02;linear,0.1;diffusealpha,1;addx,20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=cmd(horizalign,center;x,p1evalx+100;y,p1evaly-15);
			OnCommand=function(self)
				if fail then
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1)
				elseif fail and goods ~= 0 then
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1)
				elseif not fail and award or goodfc then
					if award == 'StageAward_FullComboW1' then
						self:draworder(0):zoom(4):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(1):diffusealpha(1)
					else
						self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1):sleep(0.2):smooth(0.4):addy(35)
					end
				else
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1)
				end
			end
		};
		LoadActor("_sparkle") .. {
			InitCommand=function(self) self:diffusealpha(0):x(p1evalx+100):y(p1evaly-25) end;
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward();
				if award == 'StageAward_FullComboW1' then
					self:visible(true):sleep(1.55):queuecommand("Sparkle")
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
			SparkleCommand=function(self) self:x(math.random(p1evalx+60,p1evalx+140)):y(math.random(p1evaly-65,p1evaly+15)):zoom(0.75):diffusealpha(1):linear(0.5):zoom(1):diffusealpha(0):queuecommand("Sparkle") end;
		};	
	};
	
	-- P1 Difficulty Display
if not GAMESTATE:IsCourseMode() then	
	t[#t+1] = LoadFont("_g7 star force ttf 20px") .. { 
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,1;horizalign,center;x,p1evalx+260;y,p1evaly+250);
			OnCommand=cmd(playcommand,"Set";diffusealpha,0;zoom,0.4;sleep,0.5;smooth,0.1;diffusealpha,1;zoom,0.8;smooth,0.1;zoom,0.6;);
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0.5;);
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
			TransitionCommand=cmd(playcommand,"Set";); 
			ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set";); 
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP1 ~= nil then
						local st = stepsP1:GetStepsType();
						local diff = stepsP1:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)) .. "\n" .. stepsP1:GetMeter()));
						self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
						self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			end	
	};
	t[#t+1] = Def.Quad{
		InitCommand=function(self) self:diffusealpha(1):zoomto(5000,5000):x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y):horizalign(1):x(p1evalx+250):y(p1evaly+250):diffuse(color("#000000")) end;
		OnCommand=cmd(diffusealpha,1;zoom,0.5;sleep,0.5;smooth,0.1;diffusealpha,1;zoom,1;smooth,0.1;zoom,0.75;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,1;zoom,0.5;);
	};
end
	
	-- Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	
	t[#t+1] = Def.ActorFrame { -- Judge rows
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*i;linear,0.1;diffusealpha,1;addx,20;);
		OffCommand=cmd(sleep,0.05*i;decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			InitCommand=cmd(horizalign,left;x,p1evalx;y,p1evaly+eval_offset+spacing;);
		};
		LoadFont("_coaster") .. { -- Judge names
			InitCommand=cmd(horizalign,left;zoom,0.65;diffuse,JudgmentLineToColor(cur_line);x,p1evalx+8;y,p1evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_coaster") .. { -- Judge counts
			InitCommand=cmd(horizalign,right;zoom,0.7;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));x,p1evalx+190;y,p1evaly+eval_offset+spacing);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_1))
			end,
		};
	};
	end;

		-- Score P1
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p1evalx+100;y,(p1evaly+eval_offset+23*9);horizalign,right;visible,not PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			};
			LoadFont("_coaster") .. { -- Left
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");settext,"SCORE";addx,-91);
			};
			LoadFont("_coaster") .. { -- Right
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7")addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetScore())
				end;
			};
		};
		-- Percent P1
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p1evalx+100;y,(p1evaly+eval_offset+23*9);horizalign,right;visible,PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			};
			LoadFont("_coaster") .. { -- Left
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");settext,"ACC.";addx,-91);
			};
			LoadFont("_coaster") .. { -- Right
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addx,90);
				OnCommand=function(self)
					local p1percent = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPercentDancePoints()
					self:settext(FormatPercentScore(p1percent))
				end;
			};
		};
end;

if GAMESTATE:IsHumanPlayer(PLAYER_2) then 
	local p2evalx = SCREEN_CENTER_X+170+81-31
	local p2evaly = SCREEN_TOP+150
	local eval_offset = 44
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetGrade()
	
	-- FC Badge P2
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(horizalign,center;x,p2evalx+100;y,p2evaly-40;);
		OnCommand=function(self)
			local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
			if award then
				if award == 'StageAward_FullComboW1' then
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(0.5):diffusealpha(1)
				else
					self:zoom(1):diffusealpha(0):sleep(1.7):accelerate(0.3):zoom(0.3):diffusealpha(1);
				end
			end
		end;
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor("_w3badge") .. {
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_FullComboW3' then
					self:visible(true)
				elseif award == 'StageAward_SingleDigitW3' then
					self:visible(true)
				elseif award == 'StageAward_OneW3' then
					self:visible(true):vibrate()
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
	
		LoadActor("_w2badge") .. {
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_FullComboW2' then
					self:visible(true)
				elseif award == 'StageAward_SingleDigitW2' then
					self:visible(true)
				elseif award == 'StageAward_OneW2' then
					self:visible(true):vibrate()
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
		LoadActor("_sdplus") .. {
			InitCommand=function(self) self:addx(60):addy(-75) end;
			AppearCommand=function(self) self:zoom(0):sleep(2.4):decelerate(0.2):zoom(1.25):diffusealpha(1):accelerate(0.2):zoom(1) end;
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_SingleDigitW3' then
					self:visible(true):queuecommand("Appear")
				elseif award == 'StageAward_SingleDigitW2' then
					self:visible(true):queuecommand("Appear")
				elseif award == 'StageAward_OneW3' then
					self:visible(true):queuecommand("Appear"):vibrate()
				elseif award == 'StageAward_OneW2' then
					self:visible(true):queuecommand("Appear"):vibrate()
				else
					self:visible(false)
				end;
			end;
		};	
	};
	t[#t+1] = Def.ActorFrame {	
		LoadActor("_bw1badge") .. {
			InitCommand=function(self) self:xy(SCREEN_RIGHT-107,SCREEN_TOP+132) end;
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_FullComboW1' then
					self:visible(true):zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(0.5):diffusealpha(1)
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
	};
	t[#t+1] = Def.ActorFrame { -- Sounds
		LoadActor("_badge") .. {
			OnCommand=function(self) self:sleep(1.9):queuecommand("Play") end;
			PlayCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award then
					if award ~= 'StageAward_FullComboW1' then
						self:play()
					else
						self:stop()
					end
				else
					self:stop()
				end
			end;
		};
		LoadActor("_perfect") .. {
			OnCommand=function(self) self:sleep(1.45):queuecommand("Play") end;
			PlayCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_FullComboW1' then
					self:play()
				else
					self:stop()
				end
			end;
		};
		LoadActor("_plus") .. {
			OnCommand=function(self) self:sleep(2.3):queuecommand("Play") end;
			PlayCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_SingleDigitW3' then
					self:play()
				elseif award == 'StageAward_SingleDigitW2' then
					self:play()
				else
					self:stop()
				end
			end;
		};
	};
	
	-- Grade P2
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.02;linear,0.2;diffusealpha,1;addx,-20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=cmd(zoom,0.7;horizalign,center;x,p2evalx+100;y,p2evaly-13);
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award then
					if award == 'StageAward_FullComboW1' then
						self:draworder(0):zoom(4):diffusealpha(0):sleep(0.8):accelerate(0.75):zoom(1):diffusealpha(1)
					else
						self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1):sleep(0.2):smooth(0.4):addy(35)
					end
				else
					self:zoom(2):diffusealpha(0):sleep(0.8):accelerate(0.3):zoom(1):diffusealpha(1)
				end
			end
		};
		LoadActor("_sparkle") .. {
			InitCommand=function(self) self:diffusealpha(0):x(p2evalx+100):y(p2evaly-25) end;
			OnCommand=function(self)
				local award = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward();
				if award == 'StageAward_FullComboW1' then
					self:visible(true):sleep(1.55):queuecommand("Sparkle")
				else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
			SparkleCommand=function(self) self:x(math.random(p2evalx+60,p2evalx+140)):y(math.random(p2evaly-65,p2evaly+15)):zoom(0.75):diffusealpha(1):linear(0.5):zoom(1):diffusealpha(0):queuecommand("Sparkle") end;
		};	
	};
	
		-- p2 Difficulty Display
if not GAMESTATE:IsCourseMode() then	
	t[#t+1] = LoadFont("_g7 star force ttf 20px") .. { 
			  InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,1;horizalign,center;x,p2evalx-55;y,p2evaly+250);
			  OnCommand=cmd(playcommand,"Set";diffusealpha,0;zoom,0.4;sleep,0.5;smooth,0.1;diffusealpha,1;zoom,0.8;smooth,0.1;zoom,0.6;);
			  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
			  CurrentStepsp2ChangedMessageCommand=cmd(playcommand,"Set";); 
			  TransitionCommand=cmd(playcommand,"Set";); 
			  ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set";); 
			  SetCommand=function(self)
				stepsp2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsp2 ~= nil then
						local st = stepsp2:GetStepsType();
						local diff = stepsp2:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)) .. "\n" .. stepsp2:GetMeter()));
						self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
						self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			  end	
		};
		
	end
	
	--Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*i;linear,0.1;diffusealpha,1;addx,-20;);
		OffCommand=cmd(sleep,0.05*i;decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			InitCommand=cmd(horizalign,left;x,p2evalx;y,p2evaly+eval_offset+spacing;);
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,left;zoom,0.65;diffuse,JudgmentLineToColor(cur_line);x,p2evalx+8;y,p2evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,right;zoom,0.7;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));x,p2evalx+190;y,p2evaly+eval_offset+spacing);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_2))
			end,
		};
	};
	end;
	
		-- Score P2
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*9;horizalign,right;visible,not PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,-20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);	
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"SCORE";addx,-91;addy,-1);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetScore())
				end;
			};
		};
		-- Percent
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*9;horizalign,right;visible,PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,-20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);		
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");settext,"ACC.";addx,-91);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addx,90);
				OnCommand=function(self)
					local p2percent = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetPercentDancePoints()
					self:settext(FormatPercentScore(p2percent))
				end;
			};
		};
		
end;

return t;